/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials.lunarevent;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.enhancedcelestials.EnhancedCelestials;
import corgitaco.enhancedcelestials.api.lunarevent.LunarEvent;
import corgitaco.enhancedcelestials.api.lunarevent.LunarTextComponents;
import corgitaco.enhancedcelestials.api.lunarevent.client.LunarEventClientSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;

public class HarvestMoon
extends LunarEvent {
    public static final Codec<HarvestMoon> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)LunarEventClientSettings.CODEC.fieldOf("clientSettings").forGetter(clientSettings -> clientSettings.getClientSettings()), (App)Codec.INT.fieldOf("minNumberOfNightsBetween").forGetter(clientSettings -> clientSettings.getMinNumberOfNightsBetween()), (App)Codec.DOUBLE.fieldOf("chance").forGetter(clientSettings -> clientSettings.getChance()), (App)Codec.list((Codec)Codec.INT).fieldOf("validMoonPhases").forGetter(clientSettings -> new ArrayList<Integer>(clientSettings.getValidMoonPhases())), (App)LunarTextComponents.CODEC.fieldOf("textComponents").forGetter(blueMoon -> blueMoon.getTextComponents()), (App)Codec.BOOL.fieldOf("blockSleeping").forGetter(clientSettings -> clientSettings.blockSleeping()), (App)Codec.list((Codec)class_2960.field_25139).fieldOf("enhancedCrops").forGetter(clientSettings -> new ArrayList<class_2960>(clientSettings.cropTags)), (App)Codec.DOUBLE.fieldOf("cropDropMultiplier").orElse((Object)2.5).forGetter(clientSettings -> clientSettings.cropDropMultiplier)).apply((Applicative)builder, HarvestMoon::new));
    private final List<Object> enhancedCrops = new ArrayList<Object>();
    private final Collection<class_2960> cropTags;
    private final double cropDropMultiplier;

    public HarvestMoon(LunarEventClientSettings clientSettings, int minNumberOfNightsBetween, double chance, Collection<Integer> validMoonPhases, LunarTextComponents lunarTextComponents, boolean blockSleeping, Collection<class_2960> cropTags, double cropDropMultiplier) {
        this(clientSettings, minNumberOfNightsBetween, chance, validMoonPhases, lunarTextComponents, blockSleeping, cropTags, cropDropMultiplier, true);
    }

    public HarvestMoon(LunarEventClientSettings clientSettings, int minNumberOfNightsBetween, double chance, Collection<Integer> validMoonPhases, LunarTextComponents lunarTextComponents, boolean blockSleeping, Collection<class_2960> cropTags, double cropDropMultiplier, boolean serializeCrops) {
        super(clientSettings, minNumberOfNightsBetween, chance, validMoonPhases, lunarTextComponents, blockSleeping);
        this.cropTags = cropTags;
        this.cropDropMultiplier = cropDropMultiplier;
        if (serializeCrops) {
            for (class_2960 tagID : cropTags) {
                if (tagID.method_12832().contains("item_tag_")) {
                    tagID = new class_2960(tagID.method_12836(), tagID.method_12832().replace("item_tag_", ""));
                    this.enhancedCrops.add(class_6862.method_40092((class_5321)class_2378.field_25108, (class_2960)tagID));
                    continue;
                }
                Optional optional = class_2378.field_11142.method_17966(tagID = new class_2960(tagID.method_12836(), tagID.method_12832()));
                if (optional.isPresent()) {
                    this.enhancedCrops.add(optional.get());
                    continue;
                }
                EnhancedCelestials.LOGGER.error("\"" + tagID + "\" is not a valid item ID!");
            }
        }
    }

    @Override
    public void onBlockItemDrop(class_3218 world, class_1799 itemStack) {
        class_1792 item = itemStack.method_7909();
        for (Object enhancedCrop : this.enhancedCrops) {
            if (enhancedCrop instanceof class_6862) {
                class_6862 tagKey = (class_6862)enhancedCrop;
                if (!class_2378.field_11142.method_40260(tagKey).method_40241((class_6880)itemStack.method_7909().method_40131())) continue;
                itemStack.method_7939((int)((double)itemStack.method_7947() * this.cropDropMultiplier));
                break;
            }
            if (!(enhancedCrop instanceof class_1792) || enhancedCrop != item) continue;
            itemStack.method_7939((int)((double)itemStack.method_7947() * this.cropDropMultiplier));
            break;
        }
        super.onBlockItemDrop(world, itemStack);
    }

    @Override
    public Codec<? extends LunarEvent> codec() {
        return CODEC;
    }
}

